package gov.va.cpss.service;

/**
 * Interface for the sFTP Connection Properties for SftpService.
 * 
 * @author Brad Pickle
 *
 */
public interface SftpConnectionProperties {

	/** The Constant AT_SIGN. */
	public static final String AT_SIGN = "@";

	/** The Constant COLON. */
	public static final String COLON = ":";

	/** The Constant SLASH. */
	public static final String SLASH = "/";

	/** The Constant SFTP_URL_PREFIX. */
	public static final String SFTP_URL_PREFIX = "sftp" + COLON + SLASH + SLASH;

	/**
	 * Get the host name or IP address for the sFTP server.
	 * 
	 * @return The host name or IP address for the sFTP server.
	 */
	String getHost();

	/**
	 * Set the host name or IP address for the sFTP server.
	 * 
	 * @param host
	 *            The host name or IP address for the sFTP server.
	 */
	void setHost(String host);

	/**
	 * Get the user name for the connection to the given sFTP server.
	 * 
	 * @return The user name for the sFTP connection.
	 */
	String getUsername();

	/**
	 * Set the user name for the connection to the given sFTP server.
	 * 
	 * @param username
	 *            The user name for the sFTP connection.
	 */
	void setUsername(String username);

	/**
	 * Get the password for the connection to the given sFTP server.
	 * 
	 * @return The password for the sFTP connection.
	 */
	String getPassword();

	/**
	 * Set the password for the connection to the given sFTP server.
	 * 
	 * @param password
	 *            The password for the sFTP connection.
	 */
	void setPassword(String password);

	/**
	 * Get the private key path for the connection to the given sFTP server.
	 * 
	 * @return The private key path for the sFTP connection.
	 */
	String getPrivateKey();

	/**
	 * Set the private key path for the connection to the given sFTP server.
	 * 
	 * @param privateKey
	 *            The private key path for the sFTP connection.
	 */
	void setPrivateKey(String privateKey);

	/**
	 * Get the Encoded Base URI for the sFTP connection. The Encoded Base URI is
	 * the String used to specify the URI to a resource without the path to the
	 * resource. It includes the scheme (sftp), username, password and server,
	 * i.e.:
	 * 
	 * sftp://encodeduser:encodedpassword@servername
	 * 
	 * @return The Encoded Base URI for the sFTP connection.
	 */
	String getEncodedBaseUri();

}
