package gov.va.cpss.service;

/**
 * The Result returned from service call.
 * It contains: a boolean that tells the service call is successful or not;
 *              a message that tells if something is wrong; and
 *              a results array.
 * 
 * (Sprint 2 - Story 325577 Update ICNs / Task 325578 Business service implementation to update ICN across CBSS.)
 * 
 * Copyright HPE / VA
 * June 6, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 *
 * Added generic type.
 * 
 * @author Yiping Yao
 * @version 2.0.0
 * 
 *
 * Removed object array.
 * 
 * Copyright DXC / VA
 * June 9, 2017
 * 
 * @author Yiping Yao
 * @version 3.0.0
 * 
 */
public class Result<T>
{
	private boolean successful = true;
	private String message = null;
    private T t;
	
	/**
	 * Default constructor
	 */
	public Result()
	{
		// Auto-generated constructor stub
	}

	/**
	 * Constructor
	 * 
	 * @param inSuccessful
	 * @param inMessage
	 * @param inT
	 */
	public Result(boolean inSuccessful, String inMessage, T inT)
	{
		this.successful = inSuccessful;
		this.message = inMessage;
		this.t = inT;
	}

	/**
	 * @return the successful
	 */
	public boolean isSuccessful()
	{
		return this.successful;
	}

	/**
	 * @param inSuccessful the successful to set
	 */
	public void setSuccessful(boolean inSuccessful)
	{
		this.successful = inSuccessful;
	}

	/**
	 * @return the message
	 */
	public String getMessage()
	{
		return this.message;
	}

	/**
	 * @param inMessage the message to set
	 */
	public void setMessage(String inMessage)
	{
		this.message = inMessage;
	}

    /**
     * @return the t
     */
    public T get()
    {
        return this.t;
    }

    /**
     * @param inT the t to set
     */
    public void set(T inT)
    {
        this.t = inT;
    }
}
