package gov.va.cpss.service;

/**
 * Used to sort files from the FTP server by their dates.
 * The FileInfo class contains a date as a long.
 */
public class FileData implements Comparable<FileData>{
	
	private String fileName;
	private long modifiedDate;
	
	public FileData(String fileName, long modifiedDate) {
		this.fileName = fileName;
		this.modifiedDate = modifiedDate;
	}
	
	public String getFileName() {
		return fileName;
	}
	
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	
	public long getModifiedDate() {
		return modifiedDate;
	}
	
	public void setModifiedDate(long modifiedDate) {
		this.modifiedDate = modifiedDate;
	}
	
	@Override
	public int compareTo(FileData other) {
		return new Long(modifiedDate).compareTo(other.modifiedDate);
	}
}
