package gov.va.cpss.service;

import java.util.Properties;

import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;
import static gov.va.cpss.ESAPI.EsapiValidator.validateStringInput;
import static gov.va.cpss.ESAPI.EsapiValidationType.LOG_FORGING;
/**
 * Service class for handling activities related to Sending Email.
 * 
 * @author CBSS Team developer
 */
@Service
public class EmailService {

	private static final Logger logger = Logger.getLogger(EmailService.class.getCanonicalName());

	// String from set in xml configuration.
	private String fromEmailAddress;

	public EmailService() {
	}

	public String getFromEmailAddress() {
		return fromEmailAddress;
	}

	public void setFromEmailAddress(String fromEmailAddress) {
		this.fromEmailAddress = fromEmailAddress;
	}

	/**
	 * @param toAddress
	 * @param subject
	 * @param msgBody
	 * @return
	 */
	public boolean cpssReadyToSendEmail(String toAddress, String subject, String msgBody) {

		/**** Start of the email send ***/
		Properties props = System.getProperties();

		/* you can get “smtpHostServer” value from “System.getProperties();”. */
		Session session = Session.getInstance(props, null);

		boolean successful = false;

		logger.info("SimpleEmail Before Session call Start");

		try {
			// Create a default MimeMessage object.
			MimeMessage message = new MimeMessage(session);
			// Set From: header field of the header.
			message.setFrom(new InternetAddress(fromEmailAddress));
			// Set To: header field of the header.
			message.addRecipient(Message.RecipientType.TO, new InternetAddress(toAddress));
			// Set Subject: header field
			message.setSubject(subject);
			// Now set the actual message
			message.setText(msgBody);

			// Send message
			Transport.send(message);
			successful = true;
			logger.info("Sent message successfully....");
		} catch (MessagingException mex) {
			// mex.printStackTrace();
			logger.error("Problem connecting to email server");
			logger.info("\nto: " + validateStringInput(toAddress, LOG_FORGING) 
			+ "\nsubject: " + validateStringInput(subject, LOG_FORGING) 
			+ "\n message: " + validateStringInput(msgBody, LOG_FORGING));
		}

		/*** End of email send ****/
		return successful;
	}
}
