package gov.va.cpss.model.updatestation;

import java.beans.PropertyEditorSupport;

import org.apache.log4j.Logger;

public class AddressEditor  extends PropertyEditorSupport {

    private final Logger addressLogger;

    public AddressEditor() {
        addressLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public void setAsText(String text) {
        try {
        	// Need to account for trailing whitespace, because FixedLengthTokenizer trims trailing whitespace.
        	if(text.length() > 0) {
        		if(text.length() <= 40) {
        			setValue(new Address(text.substring(0, Math.min(40, text.length())), "", ""));
        		}
        		else if(text.length() <= 80) {
        			setValue(new Address(text.substring(0, 40), text.substring(40, Math.min(80, text.length())), ""));
        		}
        		else {
        			setValue(new Address(text.substring(0, 40), text.substring(40,80), text.substring(80,120)));
        		}
        	}
        } catch (NumberFormatException e) {
            addressLogger.error("Caught exception: " + e.getMessage());
            throw (e);
        }
    }
}
