package gov.va.cpss.model.sendapps;

import java.io.Serializable;

import gov.va.cpss.model.ps.RecordType;
import gov.va.cpss.model.ps.Transaction;

@SuppressWarnings("nls")
//public class SendAppsPDRecord extends SendAPPSRecord implements Serializable {
public class SendAppsPDRecord extends Transaction implements Serializable, SendAPPSRecord<RecordType> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 2996088123183034763L;

	private String icn;
	private int seqNum;
	private String stationDesc;
	private long transAmount;
	
	public String getIcn() {
		return this.icn;
	}

	public void setIcn(String inIcn) {
		this.icn = inIcn;
	}

	public int getSeqNum() {
		return this.seqNum;
	}
	public void setSeqNum(int inSeqNum) {
		this.seqNum = inSeqNum;
	}

	public String getStationDesc() {
		return this.stationDesc;
	}

	public void setStationDesc(String inStationDesc) {
		this.stationDesc = inStationDesc;
	}

	public long getTransAmount() {
		return this.transAmount;
	}

	public void setTransAmount(long inTransAmount) {
		this.transAmount = inTransAmount;
	}
	
	@Override
	public String toFileOutputString() {
		return String.format("%-2s%-17s%04d%-8s%-5s%09d%-254s",
				getType(), this.icn, Integer.valueOf(this.seqNum), this.datePosted, this.stationDesc, Long.valueOf(this.transAmount), getFiller());
	}

	@Override
	public String toString() {
		return "SendAppsPDRecord [id=" + this.id + ", icn=" + this.icn + ", seqNum=" + this.seqNum 
				+ ", datePosted=" + this.datePosted + ", stationDesc=" + this.stationDesc 
				+ ", transAmount=" + this.transAmount + "]";
	}
}
