package gov.va.cpss.model.ps;

import java.util.Date;

import gov.va.cpss.model.AITCDollar;

/**
 * Abstract model class for Transaction.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 */
public abstract class Transaction extends PSAbstractModel<RecordType>
{
    // Properties
    protected Date datePosted;
    protected String datePostedStr;
    protected AITCDollar transactionAmount;
    protected String transactionAmountStr;


    //
    // Constructors
    //
    public Transaction()
    {
        // Default constructor
    }

    public Transaction(final Transaction inTransaction)
    {
        this.datePosted = inTransaction.datePosted;
        this.datePostedStr = inTransaction.datePostedStr;
        this.transactionAmount = inTransaction.transactionAmount;
        this.transactionAmountStr = inTransaction.transactionAmountStr;
    }


    //
    // Access Methods
    //
    /**
     * @return the datePosted
     */
    public Date getDatePosted()
    {
        return this.datePosted;
    }

    /**
     * @param inDatePosted the datePosted to set
     */
    public void setDatePosted(Date inDatePosted)
    {
        this.datePosted = inDatePosted;
    }

    /**
     * @return the datePostedStr
     */
    public String getDatePostedStr()
    {
        return this.datePostedStr;
    }

    /**
     * @param inDatePostedStr the datePostedStr to set
     */
    public void setDatePostedStr(String inDatePostedStr)
    {
        this.datePostedStr = inDatePostedStr;

        this.datePosted = parseDate(this.datePostedStr);
    }

    /**
     * @return the transactionAmount
     */
    public AITCDollar getTransactionAmount()
    {
        return this.transactionAmount;
    }

    /**
     * @param inTransactionAmount the transactionAmount to set
     */
    public void setTransactionAmount(AITCDollar inTransactionAmount)
    {
        this.transactionAmount = inTransactionAmount;

    }

    /**
     * @return the transactionAmountStr
     */
    public String getTransactionAmountStr()
    {
        return this.transactionAmountStr;
    }

    /**
     * @param inTransactionAmountStr the transactionAmountStr to set
     */
    public void setTransactionAmountStr(String inTransactionAmountStr)
    {
        this.transactionAmountStr = inTransactionAmountStr;

        if (this.transactionAmountStr != null && !this.transactionAmountStr.isEmpty())
        {
            this.transactionAmount = AITCDollar.fromString(this.transactionAmountStr);
        }
    }
}