package gov.va.cpss.model.ps;

import java.sql.Timestamp;

import org.apache.commons.lang.StringUtils;

/**
 * Model class for APSSite.
 * 
 * @author Yiping Yao
 * @version 1.0 - 20161024
 */
public abstract class Site extends PSAbstractModel<RecordType>
{
    // Properties
    protected long seqNum;
    protected long totSeqNum;
    protected String seqNumStr;
    protected String totSeqNumStr;
    protected String facilityNum;
    protected String facilityPhoneNum;
    protected Timestamp processDate;
    protected String processDateStr;

    /**
     * @return the seqNum
     */
    public long getSeqNum()
    {
        return this.seqNum;
    }

    /**
     * @param inSeqNum the seqNum to set
     */
    public void setSeqNum(long inSeqNum)
    {
        this.seqNum = inSeqNum;
    }

    /**
     * @return the totSeqNum
     */
    public long getTotSeqNum()
    {
        return this.totSeqNum;
    }

    /**
     * @param inTotSeqNum the totSeqNum to set
     */
    public void setTotSeqNum(long inTotSeqNum)
    {
        this.totSeqNum = inTotSeqNum;
    }

    /**
     * @return the seqNumStr
     */
    public String getSeqNumStr()
    {
        return this.seqNumStr;
    }

    /**
     * @param inSeqNumStr the seqNumStr to set
     */
    public void setSeqNumStr(String inSeqNumStr)
    {
        this.seqNumStr = inSeqNumStr;

        if (this.seqNumStr != null &&
            StringUtils.isNumeric(this.seqNumStr))
        {
            this.seqNum = Integer.parseInt(this.seqNumStr);
        }
    }

    /**
     * @return the totSeqNumStr
     */
    public String getTotSeqNumStr()
    {
        return this.totSeqNumStr;
    }

    /**
     * @param inTotSeqNumStr the totSeqNumStr to set
     */
    public void setTotSeqNumStr(String inTotSeqNumStr)
    {
        this.totSeqNumStr = inTotSeqNumStr;

        if (this.totSeqNumStr != null &&
            StringUtils.isNumeric(this.totSeqNumStr))
        {
            this.totSeqNum = Integer.parseInt(this.totSeqNumStr);
        }
    }

    /**
     * @return the facilityNum
     */
    public String getFacilityNum()
    {
        return this.facilityNum;
    }

    /**
     * @param inFacilityNum the facilityNum to set
     */
    public void setFacilityNum(String inFacilityNum)
    {
        this.facilityNum = inFacilityNum;
    }

    /**
     * @return the facilityPhoneNum
     */
    public String getFacilityPhoneNum()
    {
        return this.facilityPhoneNum;
    }

    /**
     * @param inFacilityPhoneNum the facilityPhoneNum to set
     */
    public void setFacilityPhoneNum(String inFacilityPhoneNum)
    {
        this.facilityPhoneNum = inFacilityPhoneNum;
    }

    /**
     * @return the processDate
     */
    public Timestamp getProcessDate()
    {
        return this.processDate;
    }

    /**
     * @param inProcessDate the processDate to set
     */
    public void setProcessDate(Timestamp inProcessDate)
    {
        this.processDate = inProcessDate;
    }

    /**
     * @return the processDateStr
     */
    public String getProcessDateStr()
    {
        return this.processDateStr;
    }

    /**
     * @param inProcessDateStr the processDateStr to set
     */
    public void setProcessDateStr(String inProcessDateStr)
    {
        this.processDateStr = inProcessDateStr;

        this.processDate = new Timestamp(parseDate(this.processDateStr).getTime());
    }

}