package gov.va.cpss.model.ps;

import org.apache.commons.lang.StringUtils;

/**
 * Abstract model class for Patient.
 * 
 * @author Yiping Yao
 * @version 1.0 - 20161024
 *
 */
public abstract class Patient extends PSAbstractModel<RecordType>
{
    // Properties
    protected String accountNumber;
    protected String icn;
    protected long dfn;
    protected String dfnStr;
    protected String lastName;
    protected String firstName;
    protected String middleName;
    protected String address1;
    protected String address2;
    protected String address3;
    protected String city;
    protected String state;
    protected String zipCode;
    protected String country;


    //
    // Constructor
    //
    public Patient()
    {
        // Default constructor
    }

    public Patient(final Patient inPatient)
    {
        this.accountNumber = inPatient.accountNumber;
        this.icn = inPatient.icn;
        this.dfn = inPatient.dfn;
        this.dfnStr = inPatient.dfnStr;
        this.lastName = inPatient.lastName;
        this.firstName = inPatient.firstName;
        this.middleName = inPatient.middleName;
        this.address1 = inPatient.address1;
        this.address2 = inPatient.address2;
        this.address3 = inPatient.address3;
        this.city = inPatient.city;
        this.state = inPatient.state;
        this.zipCode = inPatient.zipCode;
        this.country = inPatient.country;
    }

    //
    // Access Methods
    //
    /**
     * @return the accountNumber
     */
    public String getAccountNumber()
    {
        return this.accountNumber;
    }

    /**
     * @param inAccountNumber the accountNumber to set
     */
    public void setAccountNumber(String inAccountNumber)
    {
        this.accountNumber = inAccountNumber;
    }

    /**
     * @return the icn
     */
    public String getIcn()
    {
        return this.icn;
    }

    /**
     * @param inIcn the icn to set
     */
    public void setIcn(String inIcn)
    {
        this.icn = inIcn;
    }

    /**
     * @return the dfn
     */
    public long getDfn()
    {
        return this.dfn;
    }

    /**
     * @param inDfn the dfn to set
     */
    public void setDfn(long inDfn)
    {
        this.dfn = inDfn;
    }

    /**
     * @return the dfnStr
     */
    public String getDfnStr()
    {
        return this.dfnStr;
    }

    /**
     * @param inDfnStr the dfnStr to set
     */
    public void setDfnStr(String inDfnStr)
    {
        this.dfnStr = inDfnStr;

        if (this.dfnStr != null &&
            StringUtils.isNumeric(this.dfnStr))
        {
            this.dfn = Long.parseLong(this.dfnStr);
        }
    }

    /**
     * @return the lastName
     */
    public String getLastName()
    {
        return this.lastName;
    }

    /**
     * @param inLastName the lastName to set
     */
    public void setLastName(String inLastName)
    {
        this.lastName = inLastName;
    }

    /**
     * @return the firstName
     */
    public String getFirstName()
    {
        return this.firstName;
    }

    /**
     * @param inFirstName the firstName to set
     */
    public void setFirstName(String inFirstName)
    {
        this.firstName = inFirstName;
    }

    /**
     * @return the middleName
     */
    public String getMiddleName()
    {
        return this.middleName;
    }

    /**
     * @param inMiddleName the middleName to set
     */
    public void setMiddleName(String inMiddleName)
    {
        this.middleName = inMiddleName;
    }

    /**
     * @return the address1
     */
    public String getAddress1()
    {
        return this.address1;
    }

    /**
     * @param inAddress1 the address1 to set
     */
    public void setAddress1(String inAddress1)
    {
        this.address1 = inAddress1;
    }

    /**
     * @return the address2
     */
    public String getAddress2()
    {
        return this.address2;
    }

    /**
     * @param inAddress2 the address2 to set
     */
    public void setAddress2(String inAddress2)
    {
        this.address2 = inAddress2;
    }

    /**
     * @return the address3
     */
    public String getAddress3()
    {
        return this.address3;
    }

    /**
     * @param inAddress3 the address3 to set
     */
    public void setAddress3(String inAddress3)
    {
        this.address3 = inAddress3;
    }

    /**
     * @return the city
     */
    public String getCity()
    {
        return this.city;
    }

    /**
     * @param inCity the city to set
     */
    public void setCity(String inCity)
    {
        this.city = inCity;
    }

    /**
     * @return the state
     */
    public String getState()
    {
        return this.state;
    }

    /**
     * @param inState the state to set
     */
    public void setState(String inState)
    {
        this.state = inState;
    }

    /**
     * @return the zipCode
     */
    public String getZipCode()
    {
        return this.zipCode;
    }

    /**
     * @param inZipCode the zipCode to set
     */
    public void setZipCode(String inZipCode)
    {
        this.zipCode = inZipCode;
    }

    /**
     * @return the country
     */
    public String getCountry()
    {
        return this.country;
    }

    /**
     * @param inCountry the country to set
     */
    public void setCountry(String inCountry)
    {
        this.country = inCountry;
    }
}