package gov.va.cpss.model.ps;

import static gov.va.cpss.model.ps.Constants.DATE_FORMAT_STRING;

import java.time.LocalDate;
import java.time.Month;
//import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;

import java.util.Calendar;

import gov.va.cpss.model.CBSSAbstractModel;

/**
 * An abstract model class for PS models, which includes some common properties and their access methods.
 * 
 * Copyright HPE / VA
 * November 4, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public abstract class PSAbstractModel<Type> extends CBSSAbstractModel
{
    // Data type
    protected Type type;

    public Type getType()
    {
        return this.type;
    }

    public void setType(Type inType)
    {
        this.type = inType;
    }

    //
    // Static methods
    //
    public static Date parseDate(final String date)
    {
        return (date == null || !StringUtils.isNumeric(date)) ? null :
               java.sql.Date.valueOf(LocalDate.parse(date, DateTimeFormatter.ofPattern(DATE_FORMAT_STRING, Locale.ENGLISH)));
    }

    public static Month parseMonth(final String month)
    {
        return (month == null || !StringUtils.isNumeric(month) || Integer.parseInt(month) < 1 || Integer.parseInt(month) > 12) ? null :
                Month.of(Integer.parseInt(month));
    }

    public static Month parseMonth(final Date date)
    {
        if (date == null)
        {
            return null;
        }

        Calendar calendar = Calendar.getInstance();

        calendar.setTime(date);

        return Month.of(calendar.get(Calendar.MONTH) + 1);

        //return (date == null) ? null : date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getMonth();
    }
}
