package gov.va.cpss.model.ps;

/**
 * 
 * This is a general account validator for VA type accounts 
 * 
 * Copyright HPE / VA
 * November 10, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public final class AccountValidator
{
    public static String message = "Not validated.";

    // Constructor
    private AccountValidator()
    {
        // Private constructor, so it cannot be instantiated.
    }

    public static boolean isValidAccountNumber(String accountNumber, String facilityNumber)
    {
        final String trimmedAccountNumber = (accountNumber == null) ? "" : accountNumber.trim();

        if (trimmedAccountNumber.length() < 11)
        {
            // Minimum length (1 (facility-number) + 9 (SSN) + 1 (Last Name) == 11)
            message = "Invalid Account Number: Does not meet minimum length requirement.";
            return false;
        }

        if ( (facilityNumber == null) ||
             (facilityNumber.length() < 1) ||
             !trimmedAccountNumber.startsWith(facilityNumber) )
        {
            message = "Invalid Account Number: Facility number does not match account number.";
            return false;
        }

        return true;
    }
}
