package gov.va.cpss.model.printack;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the PrintAckRec database table.
 * 
 * @author Brad Pickle
 */
public class PrintAckRec implements CBSSAuditDates {

	private long id;
	private Timestamp dateReceived;
	private String stationNum;
	private int statusId;
	private String fileName;
	private int batchRunId;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;
	
	private List<ADFileRecord> printAckDetailL;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Timestamp getDateReceived() {
		return dateReceived;
	}

	public void setDateReceived(Timestamp dateReceived) {
		this.dateReceived = dateReceived;
	}

	public String getStationNum() {
		return stationNum;
	}

	public void setStationNum(String stationNum) {
		this.stationNum = stationNum;
	}

	public int getStatusId() {
		return statusId;
	}

	public void setStatusId(int statusId) {
		this.statusId = statusId;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public int getBatchRunId() {
		return batchRunId;
	}

	public void setBatchRunId(int batchRunId) {
		this.batchRunId = batchRunId;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public List<ADFileRecord> getPrintAckDetailL() {
		return printAckDetailL;
	}

	public void setPrintAckDetailL(List<ADFileRecord> printAckDetailL) {
		this.printAckDetailL = printAckDetailL;
	}
	
	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		
		buffer.append("PrintAckRec [");
		buffer.append("id=").append(id);
		buffer.append(", dateReceived=").append(dateReceived);
		buffer.append(", stationNum=").append(stationNum);
		buffer.append(", statusId=").append(statusId);
		buffer.append(", fileName=").append(fileName);
		buffer.append(", batchRunId=").append(batchRunId);
		buffer.append(", createdBy=").append(createdBy);
		buffer.append(", createdDate=").append(createdDate);
		buffer.append(", modifiedBy=").append(modifiedBy);
		buffer.append(", modifiedDate=").append(modifiedDate);
		
		buffer.append(", printAckDetailL=");
		if (printAckDetailL == null) {
			buffer.append("null");
		} else {
			buffer.append("[size=").append(printAckDetailL.size());
			if (printAckDetailL.size() > 0) {
				buffer.append(", [ ");
				String delim = "";
				for (ADFileRecord adFileRecord: printAckDetailL) {
					buffer.append(delim).append(adFileRecord);
					delim = ", ";
				}
				buffer.append(" ] ");
			}
			buffer.append("]");
		}
		
		buffer.append("]");
		
		return buffer.toString();
	}
}
