package gov.va.cpss.model.fps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the PSPatient database table.
 * 
 * @author DNS  
 */
public class PSPatient extends PSRecord implements CBSSAuditDates {

	private long id;
	private PSSite psSite;
	private String patientAccount;
	private String patientLastName;
	private String patientFirstName;
	private String patientMiddleName;
	private String address1;
	private String address2;
	private String address3;
	private String city;
	private String state;
	private String zipCode;
	private String countryName;
	private Money amountDue;
	private Money prevBalance;
	private Money totalCharges;
	private Money totalCredits;
	private Money newBalance;
	private String specialNotes;
	private String specialNotesForLateSites1;
	private String specialNotesForLateSites2;
	private String rightsObligationParagraphCodes;
	private int numOfLines;
	private long dfnNumber;
	private BooleanChar largeFontInd = BooleanChar.N;
	private String icnNumber;
	private BooleanChar addressFlag = BooleanChar.N;
	private Date lastBillPrepDate;

	private String acntNumDisp;
	private int numConsolidatedSites;
	private BooleanChar lateSiteFlag;

	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;
	private List<PSDetails> psDetailsL = new ArrayList<>();

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public PSSite getPsSite() {
		return psSite;
	}

	public void setPsSite(PSSite psSite) {
		this.psSite = psSite;
	}

	public String getPatientAccount() {
		return patientAccount;
	}

	public void setPatientAccount(String patientAccount) {
		this.patientAccount = patientAccount;
	}

	public String getPatientLastName() {
		return patientLastName;
	}

	public void setPatientLastName(String patientLastName) {
		this.patientLastName = patientLastName;
	}

	public String getPatientFirstName() {
		return patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	public String getPatientMiddleName() {
		return patientMiddleName;
	}

	public void setPatientMiddleName(String patientMiddleName) {
		this.patientMiddleName = patientMiddleName;
	}

	public String getAddress1() {
		return address1;
	}

	public void setAddress1(String address1) {
		this.address1 = address1;
	}

	public String getAddress2() {
		return address2;
	}

	public void setAddress2(String address2) {
		this.address2 = address2;
	}

	public String getAddress3() {
		return address3;
	}

	public void setAddress3(String address3) {
		this.address3 = address3;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getCountryName() {
		return countryName;
	}

	public void setCountryName(String countryName) {
		this.countryName = countryName;
	}

	public Money getAmountDue() {
		return amountDue;
	}

	public void setAmountDue(Money amountDue) {
		this.amountDue = amountDue;
	}

	public Money getPrevBalance() {
		return prevBalance;
	}

	public void setPrevBalance(Money prevBalance) {
		this.prevBalance = prevBalance;
	}

	public Money getTotalCharges() {
		return totalCharges;
	}

	public void setTotalCharges(Money totalCharges) {
		this.totalCharges = totalCharges;
	}

	public Money getTotalCredits() {
		return totalCredits;
	}

	public void setTotalCredits(Money totalCredits) {
		this.totalCredits = totalCredits;
	}

	public Money getNewBalance() {
		return newBalance;
	}

	public void setNewBalance(Money newBalance) {
		this.newBalance = newBalance;
	}

	public String getSpecialNotes() {
		return specialNotes;
	}

	public void setSpecialNotes(String specialNotes) {
		this.specialNotes = specialNotes;
	}

	public String getSpecialNotesForLateSites1() {
		return specialNotesForLateSites1;
	}

	public void setSpecialNotesForLateSites1(String specialNotesForLateSites1) {
		this.specialNotesForLateSites1 = specialNotesForLateSites1;
	}

	public String getSpecialNotesForLateSites2() {
		return specialNotesForLateSites2;
	}

	public void setSpecialNotesForLateSites2(String specialNotesForLateSites2) {
		this.specialNotesForLateSites2 = specialNotesForLateSites2;
	}

	public String getRightsObligationParagraphCodes() {
		return rightsObligationParagraphCodes;
	}

	public void setRightsObligationParagraphCodes(String rightsObligationParagraphCodes) {
		this.rightsObligationParagraphCodes = rightsObligationParagraphCodes;
	}

	public int getNumOfLines() {
		return numOfLines;
	}

	public void setNumOfLines(int numOfLines) {
		this.numOfLines = numOfLines;
	}

	public long getDfnNumber() {
		return dfnNumber;
	}

	public void setDfnNumber(long dfnNumber) {
		this.dfnNumber = dfnNumber;
	}

	public BooleanChar getLargeFontInd() {
		return largeFontInd;
	}

	public String getLargeFontIndInt() {
		return largeFontInd.toInt();
	}

	public void setLargeFontInd(BooleanChar largeFontInd) {
		this.largeFontInd = largeFontInd;
	}

	public String getIcnNumber() {
		return icnNumber;
	}

	public void setIcnNumber(String icnNumber) {
		this.icnNumber = icnNumber;
	}

	public BooleanChar getAddressFlag() {
		return addressFlag;
	}

	public void setAddressFlag(BooleanChar addressFlag) {
		this.addressFlag = addressFlag;
	}

	public Date getLastBillPrepDate() {
		return lastBillPrepDate;
	}

	public void setLastBillPrepDate(Date lastBillPrepDate) {
		this.lastBillPrepDate = lastBillPrepDate;
	}

	public String getAcntNumDisp() {
		return acntNumDisp;
	}

	public void setAcntNumDisp(String acntNumDisp) {
		this.acntNumDisp = acntNumDisp;
	}

	public int getNumConsolidatedSites() {
		return numConsolidatedSites;
	}

	public void setNumConsolidatedSites(int numConsolidatedSites) {
		this.numConsolidatedSites = numConsolidatedSites;
	}

	public BooleanChar getLateSiteFlag() {
		return lateSiteFlag;
	}

	public void setLateSiteFlag(BooleanChar lateSiteFlag) {
		this.lateSiteFlag = lateSiteFlag;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public List<PSDetails> getPsDetailsL() {
		return psDetailsL;
	}

	public void setPsDetailsL(List<PSDetails> psDetailsL) {
		this.psDetailsL = psDetailsL;
	}

	public void addPSDetails(final PSDetails psDetails) {
		psDetailsL.add(psDetails);
	}

	@Override
	public String toString() {
		return "Patient [id=" + id + ", psSiteId=" + psSite.toString() + ", patientAccount=" + patientAccount
				+ ", patientLastName=" + patientLastName + ", patientFirstName=" + patientFirstName
				+ ", patientMiddleName=" + patientMiddleName + ", address1=" + address1 + ", address2=" + address2
				+ ", address3=" + address3 + ", city=" + city + ", state=" + state + ", zipCode=" + zipCode
				+ ", countryName=" + countryName + ", amountDue=" + amountDue + ", prevBalance=" + prevBalance
				+ ", totalCharges=" + totalCharges + ", totalCredits=" + totalCredits + ", newBalance=" + newBalance
				+ ", specialNotes=" + specialNotes + ", specialNotesForLateSites1=" + specialNotesForLateSites1
				+ ", specialNotesForLateSites2=" + specialNotesForLateSites2 + ", rightsObligationParagraphCodes="
				+ rightsObligationParagraphCodes + ", numOfLines=" + numOfLines + ", dfnNumber=" + dfnNumber
				+ ", icnNumber=" + icnNumber + ", addressFlag=" + addressFlag + ", lastBillPrepDate=" + lastBillPrepDate
				+ ", acntNumDisp=" + acntNumDisp + ", numConsolidatedSites=" + numConsolidatedSites + ", lateSiteFlag="
				+ lateSiteFlag + ", createdBy=" + createdBy + ", createdDate=" + createdDate + ", modifiedBy="
				+ modifiedBy + ", modifiedDate=" + modifiedDate + ", psDetailsL="
				+ ((psDetailsL == null) ? "null" : Arrays.toString(psDetailsL.toArray())) + "]";
	}

}
