package gov.va.cpss.model.fps;

import gov.va.cpss.model.BooleanChar;

/**
 * Bean class for the P1 CBS file record.
 * 
 * @author Brad Pickle
 */
public class PS1 extends PSRecord {

	private String patientAccount;
	private String icnNumber;	
	private String acntNumDisp;
	private BooleanChar lateSiteFlag;


	public String getPatientAccount() {
		return patientAccount;
	}

	public void setPatientAccount(String patientAccount) {
		this.patientAccount = patientAccount;
	}

	public String getIcnNumber() {
		return icnNumber;
	}

	public void setIcnNumber(String icnNumber) {
		this.icnNumber = icnNumber;
	}

	public String getAcntNumDisp() {
		return acntNumDisp;
	}

	public void setAcntNumDisp(String acntNumDisp) {
		this.acntNumDisp = acntNumDisp;
	}

	/**
	 * @return the lateSiteFlag
	 */
	public BooleanChar getLateSiteFlag()
	{
		return this.lateSiteFlag;
	}

	/**
	 * @param inLateSiteFlag the lateSiteFlag to set
	 */
	public void setLateSiteFlag(BooleanChar inLateSiteFlag)
	{
		this.lateSiteFlag = inLateSiteFlag;
	}

	@Override
	public String toString() {
		return "P1 [patientAccount=" + patientAccount + ", icnNumber=" + icnNumber + ", acntNumDisp=" + acntNumDisp + ", lateSiteFlag=" + this.lateSiteFlag + "]";
	}

}
