package gov.va.cpss.model.cbs;

import java.io.Serializable;
import java.util.Date;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the CBSSiteTrans database table.
 * 
 * @author DNS
 */
public class CBSSiteTrans implements CBSSAuditDates, Serializable {

	private static final long serialVersionUID = 1L;

	private long id;
	private long siteStmtId;
	private Date datePosted;
	private String transDesc;
	private Money transAmount;
	private String referenceNum;
	private int orderNum;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getSiteStmtId() {
		return siteStmtId;
	}

	public void setSiteStmtId(long siteStmtId) {
		this.siteStmtId = siteStmtId;
	}

	public Date getDatePosted() {
		return datePosted;
	}

	public void setDatePosted(Date datePosted) {
		this.datePosted = datePosted;
	}

	public String getTransDesc() {
		return transDesc;
	}

	public void setTransDesc(String transDesc) {
		this.transDesc = transDesc;
	}

	public Money getTransAmount() {
		return transAmount;
	}

	public void setTransAmount(Money transAmount) {
		this.transAmount = transAmount;
	}

	public String getReferenceNum() {
		return referenceNum;
	}

	public void setReferenceNum(String referenceNum) {
		this.referenceNum = referenceNum;
	}

	public int getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(int orderNum) {
		this.orderNum = orderNum;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	@Override
	public String toString() {
		return "CBSSiteTrans [id=" + id + ", siteStmtId=" + siteStmtId + ", datePosted=" + datePosted + ", transDesc="
				+ transDesc + ", transAmount=" + transAmount.getDoubleAsString() + ", referenceNum=" + referenceNum
				+ ", orderNum=" + orderNum + ", createdBy=" + createdBy + ", createdDate=" + createdDate
				+ ", modifiedBy=" + modifiedBy + ", modifiedDate=" + modifiedDate + "]";
	}

}
