package gov.va.cpss.model.cbs;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.BooleanChar;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the CBSSiteStmt database table.
 * 
 * @author DNS 
 */
public class CBSSiteStmt implements CBSSAuditDates, Serializable {

	private static final long serialVersionUID = 1L;

	private long id;
	private long stmtId;
	private String stationNum;
	private String stationPhoneNum;
	private Date processDate;
	private Date statementDate;
	private Money amountDue;
	private Money prevBalance;
	private Money totalCharges;
	private Money totalCredits;
	private Money newBalance;
	private String specialNotes;
	private String noParaCdes;
	private BooleanChar largeFontInd = BooleanChar.N;
	private BooleanChar arAddressFlag = BooleanChar.N;
	private Date lastBillPrepDate;
	private BooleanChar isPrimary = BooleanChar.N;
	private BooleanChar isPrimaryAddress = BooleanChar.N;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	private CBSSitePatient sitePatient;

	private List<CBSSiteTrans> siteTransL;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getStmtId() {
		return stmtId;
	}

	public void setStmtId(long stmtId) {
		this.stmtId = stmtId;
	}

	public String getStationNum() {
		return stationNum;
	}

	public void setStationNum(String stationNum) {
		this.stationNum = stationNum;
	}

	public String getStationPhoneNum() {
		return stationPhoneNum;
	}

	public void setStationPhoneNum(String stationPhoneNum) {
		this.stationPhoneNum = stationPhoneNum;
	}

	public Date getProcessDate() {
		return processDate;
	}

	public void setProcessDate(Date processDate) {
		this.processDate = processDate;
	}

	public Date getStatementDate() {
		return statementDate;
	}

	public void setStatementDate(Date statementDate) {
		this.statementDate = statementDate;
	}

	public Money getAmountDue() {
		return amountDue;
	}

	public void setAmountDue(Money amountDue) {
		this.amountDue = amountDue;
	}

	public Money getPrevBalance() {
		return prevBalance;
	}

	public void setPrevBalance(Money prevBalance) {
		this.prevBalance = prevBalance;
	}

	public Money getTotalCharges() {
		return totalCharges;
	}

	public void setTotalCharges(Money totalCharges) {
		this.totalCharges = totalCharges;
	}

	public Money getTotalCredits() {
		return totalCredits;
	}

	public void setTotalCredits(Money totalCredits) {
		this.totalCredits = totalCredits;
	}

	public Money getNewBalance() {
		return newBalance;
	}

	public void setNewBalance(Money newBalance) {
		this.newBalance = newBalance;
	}

	public String getSpecialNotes() {
		return specialNotes;
	}

	public void setSpecialNotes(String specialNotes) {
		this.specialNotes = specialNotes;
	}

	public String getNoParaCdes() {
		return noParaCdes;
	}

	public void setNoParaCdes(String noParaCdes) {
		this.noParaCdes = noParaCdes;
	}

	public BooleanChar getLargeFontInd() {
		return largeFontInd;
	}

	public void setLargeFontInd(BooleanChar largeFontInd) {
		this.largeFontInd = largeFontInd;
	}

	public BooleanChar getArAddressFlag() {
		return arAddressFlag;
	}

	public void setArAddressFlag(BooleanChar arAddressFlag) {
		this.arAddressFlag = arAddressFlag;
	}

	public Date getLastBillPrepDate() {
		return lastBillPrepDate;
	}

	public void setLastBillPrepDate(Date lastBillPrepDate) {
		this.lastBillPrepDate = lastBillPrepDate;
	}

	public BooleanChar getIsPrimary() {
		return isPrimary;
	}

	public void setIsPrimary(BooleanChar isPrimary) {
		this.isPrimary = isPrimary;
	}

	public BooleanChar getIsPrimaryAddress() {
		return isPrimaryAddress;
	}

	public void setIsPrimaryAddress(BooleanChar isPrimaryAddress) {
		this.isPrimaryAddress = isPrimaryAddress;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public CBSSitePatient getSitePatient() {
		return sitePatient;
	}

	public void setSitePatient(CBSSitePatient sitePatient) {
		this.sitePatient = sitePatient;
	}

	public List<CBSSiteTrans> getSiteTransL() {
		return siteTransL;
	}

	public void setSiteTransL(List<CBSSiteTrans> siteTransL) {
		this.siteTransL = siteTransL;
	}

	@Override
	public String toString() {
		return "CBSSiteStmt [id=" + id + ", stmtId=" + stmtId + ", stationNum=" + stationNum + ", stationPhoneNum="
				+ stationPhoneNum + ", processDate=" + processDate + ", statementDate=" + statementDate + ", amountDue="
				+ amountDue + ", prevBalance=" + prevBalance + ", totalCharges=" + totalCharges + ", totalCredits="
				+ totalCredits + ", newBalance=" + newBalance + ", specialNotes=" + specialNotes + ", noParaCdes="
				+ noParaCdes + ", largeFontInd=" + largeFontInd + ", arAddressFlag=" + arAddressFlag
				+ ", lastBillPrepDate=" + lastBillPrepDate + ", isPrimary=" + isPrimary + ", isPrimaryAddress="
				+ isPrimaryAddress + ", createdBy=" + createdBy + ", createdDate=" + createdDate + ", modifiedBy="
				+ modifiedBy + ", modifiedDate=" + modifiedDate + "]";
	}
	
}
