package gov.va.cpss.model.cbs;

import java.io.Serializable;
import java.util.Date;

import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the CBSSitePatient database table.
 * 
 * @author DNS  
 */
public class CBSSitePatient implements CBSSAuditDates, Serializable {

	private static final long serialVersionUID = 1L;

	private long id;
	private long siteStmtId;
	private String icn;
	private long dfn;
	private String oldAcntNum;
	private String firstName;
	private String lastName;
	private String middleName;
	private String address1;
	private String address2;
	private String address3;
	private String city;
	private String state;
	private String zipCode;
	private String country;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	public CBSSitePatient() {
	}

	public CBSSitePatient(final long id) {
		this.id = id;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getSiteStmtId() {
		return siteStmtId;
	}

	public void setSiteStmtId(long siteStmtId) {
		this.siteStmtId = siteStmtId;
	}

	public String getIcn() {
		return icn;
	}

	public void setIcn(String icn) {
		this.icn = icn;
	}

	public long getDfn() {
		return dfn;
	}

	public void setDfn(long dfn) {
		this.dfn = dfn;
	}

	public String getOldAcntNum() {
		return oldAcntNum;
	}

	public void setOldAcntNum(String oldAcntNum) {
		this.oldAcntNum = oldAcntNum;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getAddress1() {
		return address1;
	}

	public void setAddress1(String address1) {
		this.address1 = address1;
	}

	public String getAddress2() {
		return address2;
	}

	public void setAddress2(String address2) {
		this.address2 = address2;
	}

	public String getAddress3() {
		return address3;
	}

	public void setAddress3(String address3) {
		this.address3 = address3;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	@Override
	public String toString() {
		return "CBSStmtPatient [id=" + id + ", siteStmtId=" + siteStmtId + ", icn=" + icn + ", dfn=" + dfn
				+ ", oldAcntNum=" + oldAcntNum + ", firstName=" + firstName + ", lastName=" + lastName + ", middleName="
				+ middleName + ", address1=" + address1 + ", address2=" + address2 + ", address3=" + address3
				+ ", city=" + city + ", state=" + state + ", zipCode=" + zipCode + ", country=" + country
				+ ", createdBy=" + createdBy + ", createdDate=" + createdDate + ", modifiedBy=" + modifiedBy
				+ ", modifiedDate=" + modifiedDate + "]";
	}

}
