package gov.va.cpss.model.bal;

import java.util.Date;

import gov.va.cpss.model.cbs.CBSAccount;

/**
 * Site Balance
 */
public class SiteBalance{

	// id
	private long id;

	// CBSS account number
	private CBSAccount cbsAccount;

	// Facility number
	private String stationNum;

	// patient account number at facility
	private String oldAcctNum;
	
	private long patientDfn;
	
	//Refactor To AITC
	// patient account total balance
	private double balance;

	// patient acount's oldest bill date
	private Date oldestBillDate;

	// data process date
	private Date processDate;

	// reference back to the Site Balance Received.
	private SiteBalRec siteBalRec;

	// reference to patient account balance message.
	private PatAcntBalMsg patientAcctBalMsg;
	
	public SiteBalance(long id) {
		this.id = id;
	}

	public CBSAccount getCbsAccount() {
		return cbsAccount;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public void setCbsAccount(CBSAccount cbsAccount) {
		this.cbsAccount = cbsAccount;
	}

	public String getStationNum() {
		return stationNum;
	}

	public void setStationNum(String stationNum) {
		this.stationNum = stationNum;
	}

	public String getOldAcctNum() {
		return oldAcctNum;
	}

	public void setOldAcctNum(String oldAcctNum) {
		this.oldAcctNum = oldAcctNum;
	}

	public long getPatientDfn() {
		return patientDfn;
	}
	
	public void setPatientDfn(long patientDfn) {
		this.patientDfn = patientDfn;
	}
	public double getBalance() {
		return balance;
	}

	public void setBalance(double balance) {
		this.balance = balance;
	}

	public Date getOldestBillDate() {
		return oldestBillDate;
	}

	public void setOldestBillDate(Date oldestBillDate) {
		this.oldestBillDate = oldestBillDate;
	}

	public Date getProcessDate() {
		return processDate;
	}

	public void setProcessDate(Date processDate) {
		this.processDate = processDate;
	}

	public SiteBalRec getSiteBalRec() {
		return siteBalRec;
	}

	public void setSiteBalRec(SiteBalRec siteBalRec) {
		this.siteBalRec = siteBalRec;
	}

	public PatAcntBalMsg getPatientAcctBalMsg() {
		return patientAcctBalMsg;
	}

	public void setPatientAcctBalMsg(PatAcntBalMsg patientAcctBalMsg) {
		this.patientAcctBalMsg = patientAcctBalMsg;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "SiteBalance [id=" + id + ", cbsAccount=" + cbsAccount + ", stationNum=" + stationNum + ", oldAcctNum="
				+ oldAcctNum + ", balance=" + balance + ", oldestBillDate=" + oldestBillDate + ", processDate="
				+ processDate + ", siteBalRec=" + siteBalRec + ", patientAcctBalMsg=" + patientAcctBalMsg + "]";
	}
	

}
