package gov.va.cpss.model.bal;

import java.sql.Timestamp;

import gov.va.cpss.model.ProcessStatus;

/**
 * Site Balance Received
 */
public class SiteBalRec {

	// identifier
	private long id;

	// file name
	private String fileName;
 
	// batch job id
	private long batchRunId;

	// total number of facility processed
	private int totNumFacility;

	// total number of patient processed
	private int totNumPatient;
	
	// message status;
	private ProcessStatus status;
	
	private Integer processStatus;
	private Timestamp receivedDate;
	
	public SiteBalRec(long id) {
		this.id = id;
	}

	public SiteBalRec(int batchRunId, Integer processStatus, Timestamp receivedDate, String fileName) {
		this.batchRunId = batchRunId;
		this.processStatus = processStatus;
		this.receivedDate = receivedDate;
		this.fileName = fileName;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public long getBatchRunId() {
		return batchRunId;
	}

	public void setBatchRunId(long batchRunId) {
		this.batchRunId = batchRunId;
	}

	public int getTotNumFacility() {
		return totNumFacility;
	}

	public void setTotNumFacility(int totNumFacility) {
		this.totNumFacility = totNumFacility;
	}

	public int getTotNumPatient() {
		return totNumPatient;
	}

	public void setTotNumPatient(int totNumPatient) {
		this.totNumPatient = totNumPatient;
	}

	public ProcessStatus getStatus() {
		return status;
	}

	public void setStatus(ProcessStatus status) {
		this.status = status;
	}

	public Integer getProcessStatus() {
		return processStatus;
	}

	public void setProcessStatus(Integer processStatus) {
		this.processStatus = processStatus;
	}

	public Timestamp getReceivedDate() {
		return receivedDate;
	}

	public void setReceivedDate(Timestamp receivedDate) {
		this.receivedDate = receivedDate;
	}

}
