package gov.va.cpss.model.appsprintack;

import java.util.HashMap;
import java.util.Map;

/**
 * Base base class for the records relating to the Update Apps Print Ack file format.
 * 
 */
public class AppsPrintAckFileRecord {

	public enum DataType {
		UNDEFINED("Undefined"), PA("PA"), AD("AD");

		private static final Map<String, DataType> LOOKUP = new HashMap<>();

		private String name;

		public String getName() {
			return name;
		}

		private DataType(String name) {
			this.name = name;
		}

		public static DataType lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (DataType t : DataType.values()) {
				LOOKUP.put(t.getName(), t);
			}
		}
	}

	protected DataType type;

	public DataType getType() {
		return type;
	}

	public void setType(DataType type) {
		this.type = type;
	}

}
