package gov.va.cpss.model.apps;

import java.io.Serializable;
import java.util.List;

import gov.va.cpss.model.ps.Statement;

/**
 * Model class for the APSStmt database table.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 */
@SuppressWarnings("nls")
public class APSStmt extends Statement implements Serializable
{
    /**
     * Generated Serial Version UID 
     */
    private static final long serialVersionUID = -7137834682321765515L;

    // Properties
    private long genBatchRunId;
    private long sendBatchRunId;
    private long ackBatchRunId;
    private String accountNumDisp;

	private List<APSSiteStmt> siteStmts;

	//
	// Constructors
	//
	public APSStmt()
	{
	    // Default constructor
	}

	public APSStmt(final long inAccountId)
	{
		this.accountId = inAccountId;
	}

	public APSStmt(final long inAccountId, final int inStatusId)
	{
		this(inAccountId);
		this.statusId = inStatusId;
	}

    public APSStmt(final long batchRunProcessIdAck, final long inAccountId, final int inStatusId) {
        this(inAccountId, inStatusId);
        this.ackBatchRunId = batchRunProcessIdAck;
    }


    //
    // Access Methods
    //
    /**
     * @return the genBatchRunId
     */
    public long getGenBatchRunId()
    {
        return this.genBatchRunId;
    }

    /**
     * @param inGenBatchRunId the genBatchRunId to set
     */
    public void setGenBatchRunId(long inGenBatchRunId)
    {
        this.genBatchRunId = inGenBatchRunId;
    }

    /**
     * @return the sendBatchRunId
     */
    public long getSendBatchRunId()
    {
        return this.sendBatchRunId;
    }

    /**
     * @param inSendBatchRunId the sendBatchRunId to set
     */
    public void setSendBatchRunId(long inSendBatchRunId)
    {
        this.sendBatchRunId = inSendBatchRunId;
    }

    /**
     * @return the ackBatchRunId
     */
    public long getAckBatchRunId()
    {
        return this.ackBatchRunId;
    }

    /**
     * @param inAckBatchRunId the ackBatchRunId to set
     */
    public void setAckBatchRunId(long inAckBatchRunId)
    {
        this.ackBatchRunId = inAckBatchRunId;
    }

    /**
     * @return the siteStmts
     */
    public List<APSSiteStmt> getSiteStmts()
    {
        return this.siteStmts;
    }

    /**
     * @param inSiteStmts the siteStmts to set
     */
    public void setSiteStmts(List<APSSiteStmt> inSiteStmts)
    {
        this.siteStmts = inSiteStmts;
    }


    /**
     * @return the accountNumDisp
     */
    public String getAccountNumDisp()
    {
        if (this.accountNumDisp == null || this.accountNumDisp.isEmpty())
        {
            this.accountNumDisp = this.formatAccountNumberForDisplay();
        }

        return this.accountNumDisp;
    }

    /**
     * @param inAccountNumDisp the accountNumDisp to set
     */
    public void setAccountNumDisp(String inAccountNumDisp)
    {
        this.accountNumDisp = inAccountNumDisp;
    }

	// Other Methods
    public APSSiteStmt getPrimarySiteStmt()
	{
		if (this.siteStmts != null)
		{
			for (APSSiteStmt siteStmt : this.siteStmts)
			{
				if (siteStmt.isPrimary())
				{
					return siteStmt;
				}
			}
		}

		return null;
	}

	public APSSiteStmt getPrimaryAddressSiteStmt()
	{
		if (this.siteStmts != null)
		{
			for (APSSiteStmt siteStmt : this.siteStmts)
			{
				if (siteStmt.isPrimaryAddress())
				{
					return siteStmt;
				}
			}
		}

		return null;
	}

	public String formatAccountNumberForDisplay()
	{
		final APSSiteStmt apsSiteStmt = this.getPrimarySiteStmt();

		final String stationNum = (apsSiteStmt == null) ? "" : apsSiteStmt.getFacilityNum().trim();

		final APSSitePatient patient = (apsSiteStmt == null) ? null : apsSiteStmt.getPatient();

		final String oldAcntNum = (patient == null) ? null : patient.getAccountNumber();

		String lastName = ( (oldAcntNum == null) || (oldAcntNum.length() < (stationNum.length() + 9)) ) ?
		                  "" : oldAcntNum.substring(stationNum.length() + 9);

		return String.format("%-3.3s%010d%-5.5s", stationNum, new Long(this.accountId), lastName);
	}

    @Override
    public String toString()
    {
        return  "APSStmt [id=" + this.id + ", accountId=" + this.accountId + ", acntNumDisp=" + formatAccountNumberForDisplay() +
                ", statementDate=" + this.statementDate + ", totalAmountReceived=" + this.totalAmountReceived + ", processDate=" + this.processDate +
                ", genBatchRunId=" + this.genBatchRunId + ", sendBatchRunId=" + this.sendBatchRunId + ", ackBatchRunId=" + this.ackBatchRunId +
                ", replacedStmtId=" + this.replacedStmtId + ", statusId=" + this.statusId +
                ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", modifiedBy=" + this.modifiedBy + ", modifiedDate=" + this.modifiedDate + "]";
    }

}
