package gov.va.cpss.model.apps;

//import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.ps.PSRecord;

/**
 * 
 * Interface for the records relating to the Load APPS Data tables.
 * 
 * Copyright HPE / VA
 * October 24, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public interface APSRecord<Type extends Enum<Type>> extends PSRecord<Type>
{
    // Constants - Field lengths
    public static final int MAX_LAST_NAME_LENGTH = 20;
    public static final int MAX_FIRST_NAME_LENGTH = 10;
    public static final int MAX_MIDDLE_NAME_LENGTH = 10;
    public static final int MAX_ADDRESS_LENGTH = 40;
    public static final int MAX_CITY_LENGTH = 40;
    public static final int MAX_STATE_LENGTH = 2;
    public static final int MAX_ZIP_CODE_LENGTH = 11;
    public static final int MAX_COUNTRY_LENGTH = 20;
    public static final int MAX_DFN_LENGTH = 16;
    public static final int MAX_ICN_LENGTH = 17;
    public static final int MAX_ACNT_NUM_LENGTH = 19;
    public static final int MAX_FLAG_LENGTH = 1;
    public static final int MAX_MONTH_LENGTH = 2;
    public static final int MAX_YEAR_LENGTH = 4;
    public static final int MAX_DATE_LENGTH = 8;

    public static final String FOREIGN_STATE = "FX";
    public static final String YES_FLAG = "Y";
    public static final String NO_FLAG = "N";


    // Validate the record
    public boolean isValid();
}
