package gov.va.cpss.model.apps;

import java.io.Serializable;

import java.util.Date;

import gov.va.cpss.model.CBSSAbstractModel;

/**
 *
 * This is a model that keeps track of each Site that has been received.
 * It is similar to APSReceived in that it keeps track of each file
 * that has been received.
 * 
 * Copyright DXE / VA
 * April 24, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public class APSReceivedSite extends CBSSAbstractModel implements Serializable
{
    /**
     * Generated Serial Version UID.
     */
    private static final long serialVersionUID = 7851409515228578247L;

    // Properties
    protected long numOfMessages;
    protected long totMsgNum;
    protected String facilityNum;
    protected Date statementDate;
    protected Date receivedDate;


    //
    // Constructors
    //
    public APSReceivedSite()
    {
        // Default constructor.
    }

    public APSReceivedSite(long inId)
    {
        this.id = inId;
    }


    //
    // Access Methods
    //
    /**
     * @return the numOfMessages
     */
    public long getNumOfMessages()
    {
        return this.numOfMessages;
    }

    /**
     * @param inNumOfMessages the numOfMessages to set
     */
    public void setNumOfMessages(long inNumOfMessages)
    {
        this.numOfMessages = inNumOfMessages;
    }

    /**
     * @return the totMsgNum
     */
    public long getTotMsgNum()
    {
        return this.totMsgNum;
    }

    /**
     * @param inTotMsgNum the totMsgNum to set
     */
    public void setTotMsgNum(long inTotMsgNum)
    {
        this.totMsgNum = inTotMsgNum;
    }

    /**
     * @return the facilityNum
     */
    public String getFacilityNum()
    {
        return this.facilityNum;
    }

    /**
     * @param inFacilityNum the facilityNum to set
     */
    public void setFacilityNum(String inFacilityNum)
    {
        this.facilityNum = inFacilityNum;
    }

    /**
     * @return the statementDate
     */
    public Date getStatementDate()
    {
        return this.statementDate;
    }

    /**
     * @param inStatementDate the statementDate to set
     */
    public void setStatementDate(Date inStatementDate)
    {
        this.statementDate = inStatementDate;
    }

    /**
     * @return the receivedDate
     */
    public Date getReceivedDate()
    {
        return this.receivedDate;
    }

    /**
     * @param inReceivedDate the receivedDate to set
     */
    public void setReceivedDate(Date inReceivedDate)
    {
        this.receivedDate = inReceivedDate;
    }

    /**
     * @return the rejectionPeriod
     */
    //public int getRejectionPeriod()
    //{
    //    return this.rejectionPeriod;
    //}

    /**
     * @param inRejectionPeriod the rejectionPeriod to set
     */
    //public void setRejectionPeriod(int inRejectionPeriod)
    //{
    //    this.rejectionPeriod = inRejectionPeriod;
    //}

}
