package gov.va.cpss.model.apps;

import java.io.Serializable;

import java.util.List;
import java.util.Map.Entry;

/**
 * This is a composite data structure for Load APPS, which contains
 * a list of messages and a list of APSSite data structure.
 * 
 * Copyright DXE / VA
 * April 11, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
public class APPSCompositeData implements Serializable
{
    /**
     * Generated Serial Version UID.
     */
    private static final long serialVersionUID = -7860676632786044590L;

    // Properties
    private Entry<APSSite, List<String>> messageEntry;
    private Entry<APSSite, List<APSPatient>> siteEntry;
    private boolean valid;

    //
    // Constructors
    //
    /**
     * Default constructor.
     */
    public APPSCompositeData()
    {
        // Default constructor.
        super();
    }

    /**
     * @param inMessageEntry
     * @param inSiteEntry
     */
    public APPSCompositeData(Entry<APSSite, List<String>> inMessageEntry, Entry<APSSite, List<APSPatient>> inSiteEntry)
    {
        super();

        this.messageEntry = inMessageEntry;
        this.siteEntry = inSiteEntry;

        if (this.messageEntry != null || this.siteEntry == null)
        {
            this.valid = false;
        }
        else
        {
            this.valid = true;
        }
    }


    //
    // Access methods
    //
    /**
     * @return the messageEntry
     */
    public Entry<APSSite, List<String>> getMessageEntry()
    {
        return this.messageEntry;
    }

    /**
     * @param inMessageEntry the messageEntry to set
     */
    public void setMessageEntry(Entry<APSSite, List<String>> inMessageEntry)
    {
        this.messageEntry = inMessageEntry;
    }

    /**
     * @return the siteEntry
     */
    public Entry<APSSite, List<APSPatient>> getSiteEntry()
    {
        return this.siteEntry;
    }

    /**
     * @param inSiteEntry the siteEntry to set
     */
    public void setSiteEntry(Entry<APSSite, List<APSPatient>> inSiteEntry)
    {
        this.siteEntry = inSiteEntry;
    }

    /**
     * @return the valid
     */
    public boolean isValid()
    {
        return this.valid;
    }

    /**
     * @param inValid the valid to set
     */
    public void setValid(boolean inValid)
    {
        this.valid = inValid;
    }
}
