package gov.va.cpss.model;

import java.sql.Timestamp;
import java.util.Calendar;

import com.fasterxml.jackson.annotation.JsonFormat;

public class TestTime {

	private Timestamp testTime;

	public TestTime() {
		testTime = new Timestamp(Calendar.getInstance().getTime().getTime());
	}

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss.SSS")
	public Timestamp getTestTime() {
		return testTime;
	}

	public void setTestTime(Timestamp testTime) {
		this.testTime = testTime;
	}

	public String getServerDateString() {
		return (testTime instanceof Timestamp) ? testTime.toString() : "";
	}
}
