package gov.va.cpss.model;

/**
 * Immutable value object representing a DFN/StationNumber pair.
 * 
 * @author Brad Pickle
 *
 */
public class DfnStationNumPair {

	private long dfn;

	private String stationNum;

	public DfnStationNumPair(long dfn, String stationNum) {
		this.dfn = dfn;
		this.stationNum = stationNum;
	}

	public long getDfn() {
		return dfn;
	}

	public String getStationNum() {
		return stationNum;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}

		if ((obj == null) || (obj.getClass() != this.getClass())) {
			return false;
		}

		DfnStationNumPair other = (DfnStationNumPair) obj;

		return (dfn == other.dfn)
				&& (stationNum == other.stationNum || (stationNum != null && stationNum.equals(other.stationNum)));
	}
	
	@Override
	public int hashCode() {
		final int prime = 37;
		int result = 1;
		result = prime * result + (int)(dfn ^ (dfn >>> 32));
		result = prime * result + ((stationNum == null) ? 0 : stationNum.hashCode());
		return result;
	}

}
