package gov.va.cpss.model;

import java.util.Date;

/**
 * An abstract model class for CBSS models, which includes some common properties and their access methods.
 * 
 * Copyright HPE / VA
 * August 26, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public abstract class CBSSAbstractModel
{
    // Message
    protected String message;

    // Properties
	protected long id;
	protected int statusId;
	protected String createdBy;
	protected Date createdDate;
	protected String modifiedBy;
	protected Date modifiedDate;

	// Access methods
	/**
	 * @return the id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * @param inId the id to set
	 */
	public void setId(long inId)
	{
		this.id = inId;
	}

	/**
	 * @return the statusId
	 */
	public int getStatusId()
	{
		return this.statusId;
	}

	/**
	 * @param inStatusId the statusId to set
	 */
	public void setStatusId(int inStatusId)
	{
		this.statusId = inStatusId;
	}

	/**
	 * @return the createdBy
	 */
	public String getCreatedBy()
	{
		return this.createdBy;
	}

	/**
	 * @param inCreatedBy the createdBy to set
	 */
	public void setCreatedBy(String inCreatedBy)
	{
		this.createdBy = inCreatedBy;
	}

	/**
	 * @return the createdDate
	 */
	public Date getCreatedDate()
	{
		return this.createdDate;
	}

	/**
	 * @param inCreatedDate the createdDate to set
	 */
	public void setCreatedDate(Date inCreatedDate)
	{
		this.createdDate = inCreatedDate;
	}

	/**
	 * @return the modifiedBy
	 */
	public String getModifiedBy()
	{
		return this.modifiedBy;
	}

	/**
	 * @param inModifiedBy the modifiedBy to set
	 */
	public void setModifiedBy(String inModifiedBy)
	{
		this.modifiedBy = inModifiedBy;
	}

	/**
	 * @return the modifiedDate
	 */
	public Date getModifiedDate()
	{
		return this.modifiedDate;
	}

	/**
	 * @param inModifiedDate the modifiedDate to set
	 */
	public void setModifiedDate(Date inModifiedDate)
	{
		this.modifiedDate = inModifiedDate;
	}
}
