package gov.va.cpss.model;

import java.util.IllegalFormatException;
import java.util.UnknownFormatConversionException;

/**
 * 
 * Provides representation for boolean with 'Y' and 'N'
 * 
 * @author Brad Pickle
 *
 */
public enum BooleanChar {
	N('N', '0'), Y('Y', '1');

	private char charValue;
	private char intValue;

	BooleanChar(char charValue, char intValue) {
		this.charValue = charValue;
		this.intValue = intValue;
	}

	public char getCharValue() {
		return charValue;
	}
	
	public char getIntValue() {
		return intValue;
	}

	public boolean isTrue() {
		return (this == Y);
	}

	public static BooleanChar from(boolean bool) {
		if(bool) {
			return Y;
		}
		else {
			return N;
		}
	}
	
	public static BooleanChar from(String c) throws IllegalFormatException {
		if ((c == null) || c.isEmpty()) {
			throw new UnknownFormatConversionException("Invalid string value (" + c + ") for BooleanChar");
		}
		return from(c.charAt(0));
	}

	public static BooleanChar from(char c) {

		for (BooleanChar b : BooleanChar.values()) {
			 // Use int value or ignoring case
			if ((c == b.intValue) || (Character.toUpperCase(c) == b.charValue)) {
				return b;
			}
		}

		throw new UnknownFormatConversionException("Invalid char value (" + c + ") for BooleanChar");
	}

	@Override
	public String toString() {
		return "" + charValue;
	}
	
	public String toInt() {
		return "" + intValue;
	}
}
