package gov.va.cpss.model;

import java.util.HashMap;
import java.util.Map;

public class BatchStatus {

	public enum JobStatus {
		UNDEFINED("UNDEFINED"), NOT_RUNNING("NotRunning"), RUNNING("Running"), COMPLETE("Complete"), ERROR("Error");

		private static final Map<String, JobStatus> LOOKUP = new HashMap<String, JobStatus>();

		private String name;

		public String getName() {
			return name;
		}

		private JobStatus(String name) {
			this.name = name;
		}

		public static JobStatus lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (JobStatus s : JobStatus.values()) {
				LOOKUP.put(s.getName(), s);
			}
		}
	}

	private int id;
	private String name;
	private String description;
	private JobStatus jobStatus = JobStatus.UNDEFINED;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public JobStatus getJobStatus() {
		return jobStatus;
	}

	public void setJobStatus(JobStatus jobStatus) {
		this.jobStatus = jobStatus;
	}

}
