package gov.va.cpss.model;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

public class BatchRun {

	private static final String DATE_TIME_DISPLAY_FORMAT = "M/d/yyyy H:mm";

	private int id;
	private int jobId;
	private Timestamp startDate;
	private Timestamp endDate;
	private int statusId;
	private String message;

	private BatchStatus batchStatus;

	public BatchRun(int jobId, Timestamp startDate, int statusId) {
		this.jobId = jobId;
		this.startDate = startDate;
		this.statusId = statusId;
	}

	public BatchRun(int jobId, Timestamp startDate, Timestamp endDate, int statusId, String message) {
		this.jobId = jobId;
		this.startDate = startDate;
		this.endDate = endDate;
		this.statusId = statusId;
		this.message = message;
	}

	public BatchRun() {
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getJobId() {
		return jobId;
	}

	public void setJobId(int jobId) {
		this.jobId = jobId;
	}

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "M/d/yyyy H:mm")
	public Timestamp getStartDate() {
		return startDate;
	}

	public String getServerStartDateString() {
		return (startDate instanceof Timestamp) ? new SimpleDateFormat(DATE_TIME_DISPLAY_FORMAT).format(startDate) : "";
	}

	public void setStartDate(Timestamp startDate) {
		this.startDate = startDate;
	}

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "M/d/yyyy H:mm")
	public Timestamp getEndDate() {
		return endDate;
	}

	public String getServerEndDateString() {
		return (endDate instanceof Timestamp) ? new SimpleDateFormat(DATE_TIME_DISPLAY_FORMAT).format(endDate) : "";
	}

	public void setEndDate(Timestamp endDate) {
		this.endDate = endDate;
	}

	public int getStatusId() {
		return statusId;
	}

	public void setStatusId(int statusId) {
		this.statusId = statusId;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public BatchStatus getBatchStatus() {
		return batchStatus;
	}

	public void setBatchStatus(BatchStatus batchStatus) {
		this.batchStatus = batchStatus;
	}

}
