package gov.va.cpss.model;

import java.beans.PropertyEditorSupport;

import org.apache.log4j.Logger;

/**
 * Custom property editor used by BeanWrapperFieldSetMapper to set AITCDollar
 * fields during batch processing.
 * 
 * @author Brad Pickle
 */
public class AITCDollarEditor extends PropertyEditorSupport {

    private final Logger editorLogger = Logger.getLogger(this.getClass().getCanonicalName());
 
    @Override
    public void setAsText(String text) {
        try {
            setValue(AITCDollar.fromString(text));
        } catch (IllegalArgumentException e) {
        	editorLogger.error("Caught exception: " + e.getMessage());
            throw (e);
        }
    }
}
