package gov.va.cpss.job.updateicn;

import static gov.va.cpss.job.CbssJobProcessingConstants.BATCH_RUN_ID_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.BATCH_RUN_TIMESTAMP_KEY;

import java.sql.Timestamp;
import java.util.Calendar;

import org.apache.log4j.Logger;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.step.job.JobParametersExtractor;

public class UpdateICNJobParametersExtractor implements JobParametersExtractor {

	protected static final Logger extractorLogger = Logger
			.getLogger(UpdateICNJobParametersExtractor.class.getCanonicalName());

	@Override
	public JobParameters getJobParameters(Job job, StepExecution stepExecution) {

		Timestamp batchRunTimestamp = new Timestamp(Calendar.getInstance().getTime().getTime());
		Long batchRunTimestampValue = batchRunTimestamp.getTime();

		extractorLogger.info("Building Job Parameters for Update ICN: " + BATCH_RUN_ID_KEY + "("
				+ stepExecution.getJobParameters().getLong(BATCH_RUN_ID_KEY) + "), " + BATCH_RUN_TIMESTAMP_KEY + "("
				+ batchRunTimestampValue + ")");

		JobParametersBuilder builder = new JobParametersBuilder();
		builder.addLong(BATCH_RUN_ID_KEY, stepExecution.getJobParameters().getLong(BATCH_RUN_ID_KEY));
		builder.addLong(BATCH_RUN_TIMESTAMP_KEY, batchRunTimestampValue);

		return builder.toJobParameters();
	}
}
