package gov.va.cpss.job.sendcbs;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.adapter.ItemReaderAdapter;

import gov.va.cpss.model.fps.PSRecord;

/**
 * 
 * 
 * 
 * @author Brad Pickle
 *
 */
public class SendCBSWriteItemReader extends ItemReaderAdapter<PSRecord> implements StepExecutionListener {

	public static final String INITIALIZATION_ERROR_STATUS = "FAILURE INITIALIZING READ";

	private static final Logger logger = Logger.getLogger(SendCBSWriteItemReader.class.getCanonicalName());

	private JobExecution jobExecution;

	@Override
	public void beforeStep(StepExecution stepExecution) {
		logger.info("Before Step Execution");

		jobExecution = stepExecution.getJobExecution();
	}

	@Override
	public ExitStatus afterStep(StepExecution arg0) {
		return null;
	}

	/**
	 * Set the failure and message in the job execution context.
	 */
	private void setFailureStatusAndMessage(final String status, final String message) {
		// Set job failure.
		setFailureStatus(status);

		// Set job failure message.
		setFailureMessage(message);
	}

	/**
	 * Set the failure in the job execution context.
	 */
	private void setFailureStatus(final String status) {
		// Log job failure status.
		logger.error("Read failed with status: " + status);

		// Set job failure.
		jobExecution.getExecutionContext().putString(JOB_FAILURE_KEY, status);
	}

	/**
	 * Set the failure message in the job execution context.
	 */
	private void setFailureMessage(final String message) {
		// Log job failure message.
		logger.error("Read failure message: " + message);

		// Set job failure message.
		jobExecution.getExecutionContext().putString(JOB_FAILURE_MESSAGE_KEY, message);
	}

}
