package gov.va.cpss.job.sendcbs;

import org.apache.log4j.Logger;
import org.springframework.classify.Classifier;

import gov.va.cpss.model.fps.PSRecord;
import gov.va.cpss.model.fps.PSSite;

/**
 * Classifier used by the Send CBS batch job ClassifierLineAggregator to
 * determine which LineAggregator to use based on the type of PSRecord. 
 *  
 * @author Brad Pickle
 */
public class SendCBSClassifier implements Classifier<Object, Object> {

    private final Logger logger;

    public SendCBSClassifier() {
        logger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public Object classify(Object arg0) {

        logger.debug("Classifying record for writing");

        if (!(arg0 instanceof PSRecord)) {
            logger.error("Unable to classify object for writing");
            return PSRecord.DataType.UNDEFINED.getName();
        }
        
        PSRecord psRecord = (PSRecord) arg0;
        PSRecord.DataType psRecordType = psRecord.getType();
        
        if (psRecordType == PSRecord.DataType.PS) {
            if (!(psRecord instanceof PSSite)) {
                logger.error("Unable to classify object for writing");
                return PSRecord.DataType.UNDEFINED.getName();
            }
            
            PSRecord.DataType statementType = ((PSSite) psRecord).getStatementType();
            
            if (statementType == null) {
                logger.error("Unable to classify object for writing");
                return PSRecord.DataType.UNDEFINED.getName();
            }
            
            return psRecordType.getName() + "_" + statementType.getName();
        } else {
        	return psRecordType.getName();
        }

    }

}
