package gov.va.cpss.job.sendbill;

import java.util.ArrayList;
import java.util.List;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;

public class SendBillItemWriter<SendBillStringDTO> implements ItemWriter<List<SendBillStringDTO>>, ItemStream {

	private ItemWriter<SendBillStringDTO> delegate;

	public void setDelegate(ItemWriter<SendBillStringDTO> delegate) {
		this.delegate = delegate;
	}

	@Override
	public void open(ExecutionContext executionContext) {
		if (delegate instanceof ItemStream) {
			((ItemStream) delegate).open(executionContext);
		}
	}

	@Override
	public void update(ExecutionContext executionContext) {
		if (delegate instanceof ItemStream) {
			((ItemStream) delegate).update(executionContext);
		}
	}

	@Override
	public void close() {
		if (delegate instanceof ItemStream) {
			((ItemStream) delegate).close();
		}
	}

	@Override
	public void write(final List<? extends List<SendBillStringDTO>> items) throws Exception {
		// List<List<SendBillStringDTO>> ListOfList =
		// (List<List<SendBillStringDTO>>)items;
		List<SendBillStringDTO> singleList = new ArrayList<SendBillStringDTO>();

		for (final List<SendBillStringDTO> data : items) {
			singleList.addAll(data);
		}
		delegate.write(singleList);
	}

}
