package gov.va.cpss.job.sendbill;

import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.SEND_BILL_OUTPUT_FILE_NAME_KEY;
import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.SEND_BILL_OUTPUT_RESOURCE_KEY;
import static gov.va.cpss.job.sendbill.SendBillDataProcessingConstants.SEND_BILL_TOTAL_RECORD_COUNT;

import org.apache.log4j.Logger;
import org.springframework.batch.core.JobExecution;

import gov.va.cpss.job.SetExitStatusJobExecutionListener;
import gov.va.cpss.service.SendBillDataService;

public class SendBillDataListener extends SetExitStatusJobExecutionListener {

	private SendBillDataService sendBillDataService;
	private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

	/**
	 * @return the sendBillDataService
	 */
	public SendBillDataService getSendBillDataService() {
		return sendBillDataService;
	}

	/**
	 * @param sendBillDataService
	 *            the sendBillDataService to set
	 */
	public void setSendBillDataService(SendBillDataService sendBillDataService) {
		this.sendBillDataService = sendBillDataService;
	}

	@Override
	public void beforeJob(JobExecution jobExecution) {
		logger.info("Beginning Job Execution");
		String sendBillOutputFileName = jobExecution.getJobParameters().getString(SEND_BILL_OUTPUT_FILE_NAME_KEY);
		jobExecution.getExecutionContext().put(SEND_BILL_OUTPUT_RESOURCE_KEY,
				getSendBillDataService().getBillDataOutputResource(sendBillOutputFileName));

		jobExecution.getExecutionContext().put(SEND_BILL_TOTAL_RECORD_COUNT,
				getSendBillDataService().countSiteBalPatients());
	}
}
