package gov.va.cpss.job.sendapps;

@SuppressWarnings("nls")
public class SendAPPSProcessingConstants {

	/**
	 * The key to identify the file name for annual patient payment statement
	 */
	public static final String APPS_OUTPUT_FILE_NAME_PREFIX_KEY = "appsOutputFileNamePrefix";

	/**
	 * The key to identify the full path for the annual statements.
	 */
	public static final String APPS_OUTPUT_RESOURCE_KEY = "appsOutputResource";
	
	/**
	 * The key to identify the number of files sent to AITC.
	 */
	public static final String APPS_FILES_SENT_KEY = "totalAPPSFilesSent";
	
	/**
	 * The key to identify the amount of statements sent to AITC.
	 */
	public static final String APPS_STATEMENTS_SENT_KEY = "totalAPPSStatmentsSent";
	
	/**
	 * The key to identify the database primary key value for the CBSMessage
	 * table entry associated with the Send APPS job.
	 */
	public static final String APPS_BATCHRUNPROCESS_ID_KEY = "appsBatchRunProcessId";
	
	/**
	 * A prefix for naming Send APPS files.
	 *TODO: Find out what the postfix is supposed to be.
	 */
	public static final String APPS_OUTPUT_FILE_NAME_PREFIX = "sendAppsFile";
	
	/**
	 * The key to identify the file name for the annual statements staging
	 * file.
	 */
	public static final String APPS_OUTPUT_FILE_NAME_KEY = "appsOutputFileName";
	
	/**
	 * The key to identify the value used for the APPSStmtStatus NEW status id.
	 */
	public static final String NEW_STATUS_ID_KEY = "newStatusId";
	
	/**
	 * The key to identify the Map of annual statements by site.
	 */
	public static final String APPS_LISTS_BY_SITE_KEY = "appsListsBySite";
	
	/**
	 * The maximum number of records output per PS.
	 */
	public static final int APPS_MAX_RECORDS_PER_SITE = 9999;
	
	/**
	 * The key to identify the total patients included in the delivered APPS
	 * file.
	 */
	public static final String APPS_TOTAL_PATIENTS_INCLUDED_KEY = "appsPatientsIncluded";
}
