package gov.va.cpss.job.sendapps;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

import gov.va.cpss.service.SendAPPSService;

@SuppressWarnings("nls")
public class SendAPPSJobExecutionListener implements JobExecutionListener {

	private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());

	private SendAPPSService sendAPPSService;

	public SendAPPSService getSendAPPSService() {
		return this.sendAPPSService;
	}

	public void setSendAPPSService(SendAPPSService inSendAPPSService) {
		this.sendAPPSService = inSendAPPSService;
	}

	@Override
	public void beforeJob(JobExecution jobExecution) {
		this.logger.info("Beginning Job Execution");
		String appsOutputFileName = jobExecution.getJobParameters()
				.getString(SendAPPSProcessingConstants.APPS_OUTPUT_FILE_NAME_KEY);
		jobExecution.getExecutionContext().put(SendAPPSProcessingConstants.APPS_OUTPUT_RESOURCE_KEY,
				this.sendAPPSService.getAPPSOutputResource(appsOutputFileName));
	}

	@Override
	public void afterJob(JobExecution jobExecution) {

		if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_KEY)) {

			final String exitStatus = jobExecution.getExecutionContext().getString(JOB_FAILURE_KEY);

			if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_MESSAGE_KEY)) {

				final String exitMessage = jobExecution.getExecutionContext().getString(JOB_FAILURE_MESSAGE_KEY);

				this.logger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

				jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
			} else {

				this.logger.error("JobFailure detected, setting exit status (" + exitStatus + ")");

				jobExecution.setExitStatus(new ExitStatus(exitStatus));
			}
		} else {
			jobExecution.setExitStatus(ExitStatus.COMPLETED);
		}

		this.logger.info("Ending Job Execution");
	}

}
