package gov.va.cpss.job.sendapps;

import static gov.va.cpss.job.CbssJobProcessingConstants.PROCESSING_FAILURE_STATUS;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import gov.va.cpss.job.CBSSPagingItemProcessor;
import gov.va.cpss.model.apps.APSSiteStmt;
import gov.va.cpss.model.apps.APSStmt;
import gov.va.cpss.service.SendAPPSService;


@SuppressWarnings("nls")
public class SendAPPSItemProcessor extends CBSSPagingItemProcessor<APSStmt, List<APSStmt>> {

    private SendAPPSService sendAPPSService;
    
    private static int runCount = 0;
    

    public SendAPPSItemProcessor() {
    }

    public SendAPPSService getSendAPPSService() {
		return this.sendAPPSService;
	}

	public void setSendAPPSService(SendAPPSService inSendAPPSService) {
		this.sendAPPSService = inSendAPPSService;
	}

	@Override
	protected List<APSStmt> doProcess(final List<APSStmt> inInputItemsList) {
		this.logger.info("Loading into memory page " + ++runCount + " of annual statements.");
		
		if(Objects.isNull(inInputItemsList)) {
			stopJob(PROCESSING_FAILURE_STATUS, "Unable to obtain any annual statements.");
			return null;
		}
		
		// Avoid processing null statements by stripping them from the statement list
		final List<APSStmt> outInputItemsList = inInputItemsList.stream().filter(Objects::nonNull).collect(Collectors.toList());
		
		this.logger.debug("Found " + (inInputItemsList.size() - outInputItemsList.size()) + " null statements.");
		
		for(APSStmt apsStmt : outInputItemsList) {
			if(Objects.isNull(apsStmt.getSiteStmts())) {
				stopJob(PROCESSING_FAILURE_STATUS, "Unable to obtain site statements for APSStmt ID: " + apsStmt.getId());
				return null;
			}
			
			for(APSSiteStmt siteStmt : apsStmt.getSiteStmts()) {
				if(Objects.isNull(siteStmt.getPatient())) {
					stopJob(PROCESSING_FAILURE_STATUS, "No patient found for APSSiteStmt ID: " + siteStmt.getId());
					return null;
				}
				
				if(Objects.isNull(siteStmt.getPayments())) {
					stopJob(PROCESSING_FAILURE_STATUS, "No payments found for APSSiteStmt ID: " + siteStmt.getId());
					return null;
				} 
			}
		}
		
		return outInputItemsList;
	}
}
