package gov.va.cpss.job.loadbill;

import java.text.SimpleDateFormat;

/**
 * Constants used by Load Bill Data batch job to dynamically update the job
 * execution context during batch operations.
 * 
 * @author DNS 
 */
public final class LoadBillProcessingConstants {
	
	/**
	 * A count of the total facilities for a SiteBalRec.
	 */
	public static final String TOTAL_FACILITY_COUNT_KEY = "totalFacilityCount";
	
	/**
	 * A count of the total patients for a SiteBalRec.
	 */
	public static final String TOTAL_PATIENT_COUNT_KEY = "totalPatientCount";
	
	/**
	 * The specified format of the Load Bill date fields.
	 */
	public static final String DATE_FORMAT_STRING = "MMddyyyy";
	
	/**
	 * The formatter to use on Load Bill dates.
	 */
	public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DATE_FORMAT_STRING);
	
	/**
	 * Detected Details Errors
	 */
	public static final String DETECTED_DETAIL_ERRORS_KEY = "detailErrors";
	
	/**
	 * Key to indicate most recent header is complete.
	 */
	public static final String PU_HEADER_COMPLETE_KEY = "headerComplete";
}
