package gov.va.cpss.job.fps;

/**
 * Constants used by Process FPS Data batch job to dynamically update the job
 * execution context during batch operations.
 * 
 * @author DNS
 */
public final class FpsProcessingConstants {

	/**
	 * The key to identify the input resource.
	 */
	public static final String INPUT_RESOURCE_KEY = "inputResource";
	
	/**
	 * The key to identify the data directory holding the input resource.
	 */
	public static final String INPUT_DIRECTORY_KEY = "inputDirectory";

	/**
	 * The key to identify the database primary key value for the PSReceived
	 * table entry associated with the job.
	 */
	public static final String RECEIVED_ID_KEY = "receivedId";

	/**
	 * The key to identify the database primary key value for the PSSite table
	 * entry associated with the currently processing PS data entry.
	 */
	public static final String SITE_ID_KEY = "siteId";

	/**
	 * The key to identify the database primary key value for the PSPatient
	 * table entry associated with the currently processing PH data entry.
	 */
	public static final String PATIENT_ID_KEY = "patientId";

	/**
	 * The key to identify the rolling count of the total PS rows processed by
	 * the batch job run.
	 */
	public static final String TOTAL_SITE_COUNT_KEY = "totalSiteCount";

	/**
	 * The key to identify the rolling count of the total PH rows processed by
	 * the batch job run.
	 */
	public static final String TOTAL_STATEMENT_COUNT_KEY = "totalStatementCount";

}
