package gov.va.cpss.job.fps;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

/**
 * Custom JobExecutionListener used to process custom exit status to handle read
 * and write errors during Process FPS Data batch job execution.
 * 
 * @author DNS   
 */
public class FpsJobExecutionListener implements JobExecutionListener {

	private final Logger readerLogger;

	boolean fail = false;

	public FpsJobExecutionListener() {
		readerLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	@Override
	public void afterJob(JobExecution arg0) {

		if (arg0.getExecutionContext().containsKey(JOB_FAILURE_KEY)) {

			final String exitStatus = arg0.getExecutionContext().getString(JOB_FAILURE_KEY);

			if (arg0.getExecutionContext().containsKey(JOB_FAILURE_MESSAGE_KEY)) {

				final String exitMessage = arg0.getExecutionContext().getString(JOB_FAILURE_MESSAGE_KEY);

				readerLogger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

				arg0.setExitStatus(new ExitStatus(exitStatus, exitMessage));
			} else {

				readerLogger.error("JobFailure detected, setting exit status (" + exitStatus + ")");

				arg0.setExitStatus(new ExitStatus(exitStatus));
			}
		} else {
			arg0.setExitStatus(ExitStatus.COMPLETED);
		}

		readerLogger.info("Ending Job Execution");
	}

	@Override
	public void beforeJob(JobExecution arg0) {
		readerLogger.info("Beginning Job Execution");
	}

}
