package gov.va.cpss.job.cbs;

import java.util.List;
import java.util.Map;

import gov.va.cpss.model.fps.PSPatient;

/**
 * Interface for the runtime parameters used by the Generate CBS batch job
 * during processing.
 * 
 * @author DNS  
 */
public interface CbsRuntimeState {

	public boolean isEmpty();

	public void setEmpty(boolean empty);

	public boolean isDataError();

	public void setDataError(boolean dataError);

	/**
	 * Clears any residual values from previous use.
	 */
	public void initialize();

	/**
	 * Add entry to the PSReceived ID list.
	 */
	public boolean addPSReceivedEntry(final Long id);

	/**
	 * Add entry to the PSSite list.
	 */
	public boolean addPSSiteEntry(final Long psSite);

	/**
	 * Get the whole list of PSReceived ID.
	 */
	public List<Long> getPSReceivedIDList();

	/**
	 * Get the current PSReceived ID.
	 */
	public Long getCurrentPSReceivedID();

	/**
	 * Get the current PSSite.
	 */
	public Long getCurrentPSSiteID();

	/**
	 * Poll the next current PSReceived ID.
	 */
	public Long pollCurrentPSReceivedID();

	/**
	 * Poll the next current PSSite.
	 */
	public Long pollCurrentPSSiteID();
	
	/**
	 * Save the raw list of PSPatient into the CBS Account ID to List of PSPatient Map.
	 * 
	 * @return Boolean indicating if successfully added the patient list to the
	 *         CBS Account ID sorted map.
	 */
	public boolean savePSPatientMap(Map<Long, List<PSPatient>> queryM);
	
	/**
	 * Get the current CBS Account ID to List of PSPatient Map.
	 * @return Map of CBS Account ID to List of PSPatient.
	 */
	public Map.Entry<Long, List<PSPatient>> getCurrentPSPatientM();
	
	/**
	 * Get the next entry of the CBS Account ID to List of PSPatient Map.
	 * @return The next entry or null if empty.
	 */
	public Map.Entry<Long, List<PSPatient>> pollCurrentPSPatientM();
}
