package gov.va.cpss.job.cbs;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

import gov.va.cpss.service.FpsService;

/**
 * Query for all PSSite records associated with PSReceived in the NEW state.
 * 
 * @author DNS   
 */
public class CbsQueryNewPSSiteTasklet implements Tasklet {

	private final Logger taskletLogger;

	private FpsService fpsService;

	private CbsRuntimeState cbsRuntimeState;

	public CbsQueryNewPSSiteTasklet() {
		taskletLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	public FpsService getFpsService() {
		return fpsService;
	}

	public void setFpsService(FpsService fpsService) {
		this.fpsService = fpsService;
	}

	public CbsRuntimeState getCbsRuntimeState() {
		return cbsRuntimeState;
	}

	public void setCbsRuntimeState(CbsRuntimeState cbsRuntimeState) {
		this.cbsRuntimeState = cbsRuntimeState;
	}

	@Override
	public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {

		taskletLogger.info("Begin execute");

		// Loop through all of NEW PSReceived.
		while (!cbsRuntimeState.isDataError() && (cbsRuntimeState.pollCurrentPSReceivedID() != null)) {

			// Get all PSSite for this PSReceived.
			List<Long> psSiteL = fpsService.getPSSiteIDListForPSReceivedID(cbsRuntimeState.getCurrentPSReceivedID());

			// Set error flag if empty. This flag will be checked by the
			// subsequent reader.
			if ((psSiteL == null) || psSiteL.isEmpty()) {

				taskletLogger.error(
						"Error obtaining site list for received ID(" + cbsRuntimeState.getCurrentPSReceivedID() + ")");
				cbsRuntimeState.setDataError(true);
			} else {

				// Save the recently queried data.
				for (Long psSite : psSiteL) {
					taskletLogger.info("Adding PSSite ID: " + psSite);
					cbsRuntimeState.addPSSiteEntry(psSite);
				}
			}
		}

		taskletLogger.info("End execute");

		return RepeatStatus.FINISHED;
	}

}
