package gov.va.cpss.job.cbs;

import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

import gov.va.cpss.service.FpsService;

/**
 * Query for all PSReceived records in the NEW state.
 * 
 * @author DNS   
 */
public class CbsQueryNewPSReceivedTasklet implements Tasklet {

	private final Logger taskletLogger;

	private FpsService fpsService;

	private CbsRuntimeState cbsRuntimeState;

	public CbsQueryNewPSReceivedTasklet() {
		taskletLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	public FpsService getFpsService() {
		return fpsService;
	}

	public void setFpsService(FpsService fpsService) {
		this.fpsService = fpsService;
	}

	public CbsRuntimeState getCbsRuntimeState() {
		return cbsRuntimeState;
	}

	public void setCbsRuntimeState(CbsRuntimeState cbsRuntimeState) {
		this.cbsRuntimeState = cbsRuntimeState;
	}

	@Override
	public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {

		taskletLogger.info("Begin execute");

		// Initialize the run time parameters to clear any residual data from
		// previous use.
		cbsRuntimeState.initialize();

		// Get all the NEW PSReceived.
		List<Long> psReceivedL = fpsService.getNewPSReceivedIDList();

		if (psReceivedL.isEmpty()) {
			cbsRuntimeState.setEmpty(true);
			taskletLogger.error("No new PSReceived to process");
		} else {

			// Save the recently queried data.
			for (Long psReceived : psReceivedL) {
				taskletLogger.info("Adding PSReceived ID: " + psReceived);
				cbsRuntimeState.addPSReceivedEntry(psReceived);
			}
		}

		taskletLogger.info("End execute");

		return RepeatStatus.FINISHED;
	}

}
