package gov.va.cpss.job.cbs;

import static gov.va.cpss.job.cbs.CbsProcessingConstants.CBS_GENERATED_STATISTICS_KEY;
import static gov.va.cpss.job.cbs.CbsProcessingConstants.CBS_GENERATED_STATISTICS_LABEL;

import org.springframework.batch.core.JobExecution;

import gov.va.cpss.job.CbssJobBaseTransactionTasklet;

/**
 * Abstract base class that implements logic for a tasklet to do final
 * completion tasks.
 * 
 * @author DNS 
 */
public abstract class CbsJobBaseCompletionTasklet extends CbssJobBaseTransactionTasklet {

	protected void updateStatistics(JobExecution jobExecution, final long count) {
		// Set the completion statistics.
		jobExecution.getExecutionContext().putString(CBS_GENERATED_STATISTICS_KEY,
				CBS_GENERATED_STATISTICS_LABEL + count);
	}

}
