package gov.va.cpss.job.appsprintack;

/**
 * Constants used by Update APPS Print Ack batch job.
 * 
 * @author Andrew Vance
 */
public final class AppsUpaProcessingConstants {

	/**
	 * The key to identify the database primary key value for the BatchRun table
	 * entry associated with the job.
	 */
	public static final String BATCH_RUN_ID_KEY = "batchRunId";

	/**
	 * The key to identify the input resource.
	 */
	public static final String INPUT_RESOURCE_KEY = "inputResource";

	/**
	 * The key to identify the data directory holding the input resource.
	 */
	public static final String INPUT_DIRECTORY_KEY = "inputDirectory";

	/**
	 * The key to identify the date received of the input resource.
	 */
	public static final String DATE_RECEIVED_KEY = "dateReceived";

	/**
	 * The key to identify the total CBS received in the file being processed.
	 */
	public static final String TOTAL_APPS_RECEIVED_KEY = "totalAppsReceived";

	/**
	 * The key to identify the total CBS updated while processing the print
	 * acknowledgments.
	 */
	public static final String TOTAL_APPS_UPDATED_KEY = "totalAppsUpdated";
	
	/**
	 * The key to identify the list of batchRunProcess Ids that have been created.
	 */
	public static final String BATCH_RUN_PROCESS_ID_LIST_KEY = "batchRunProcessIdList";
	
	/**
	 * The key to identify the List of missing patient accounts.
	 */
	public static final String MISSING_PATIENT_ACCT_LIST_KEY = "missingPatientAcctList";
}
