package gov.va.cpss.job.apps;

import java.util.List;
import java.util.Map.Entry;

import gov.va.cpss.model.apps.APPSCompositeData;
import gov.va.cpss.model.apps.APSSite;

import gov.va.cpss.job.CBSSBaseItemProcessor;

/**
 * 
 * Custom ItemProcessor used by the Load APPS Payments Data batch job to process
 * records that have erred and write error messages to a flat file.
 * 
 * Copyright DXC / VA
 * April 12, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSMessageItemProcessor extends CBSSBaseItemProcessor<APPSCompositeData, Entry<APSSite, List<String>>>
{
    @Override
    public Entry<APSSite, List<String>> process(APPSCompositeData compositeData) throws Exception
    {
        this.logger.debug("Process message.");

        if (compositeData == null || compositeData.getMessageEntry() == null)
        {
            return null;
        }

        return compositeData.getMessageEntry();
    }
}
