package gov.va.cpss.job.apps;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.READ_FAILURE_STATUS;

import static gov.va.cpss.model.ps.Constants.FILE_COMPLETE_KEY;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

/**
 * Custom JobExecutionListener used to process custom exit status to handle read
 * and write errors during Load APPS Data batch job execution.
 * 
 * Copyright HPE / VA
 * October 25, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 * Copyright DXC / VA
 * April 18, 2017
 * 
 * @author Yiping Yao
 * @version 2.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSJobExecutionListener implements JobExecutionListener
{
	private Log logger = LogFactory.getLog(getClass());

	@Override
	public void afterJob(JobExecution jobExecution)
	{
	    this.logger.debug("After Job ...");

        // System failure takes precedence over data error.
        if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_KEY))
        {
            final String exitStatus = jobExecution.getExecutionContext().getString(JOB_FAILURE_KEY);

            if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_MESSAGE_KEY))
            {
                final String exitMessage = jobExecution.getExecutionContext().getString(JOB_FAILURE_MESSAGE_KEY);

                this.logger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

                jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
            }
            else
            {

                this.logger.error("JobFailure detected, setting exit status (" + exitStatus + ")");

                jobExecution.setExitStatus(new ExitStatus(exitStatus));
            }

        }
        else if (jobExecution.getExecutionContext().containsKey(FILE_COMPLETE_KEY))
        {
            final String fileCompleted = jobExecution.getExecutionContext().getString(FILE_COMPLETE_KEY);

            if (!Boolean.valueOf(fileCompleted).booleanValue())
            {
                final String exitStatus = READ_FAILURE_STATUS;
                
                final String exitMessage = "Incomplete file found.";
                
                this.logger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

                jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
            }
            else
            {
                jobExecution.setExitStatus(ExitStatus.COMPLETED);
            }
        }

		this.logger.debug("After Job: Ending Job Execution");
	}

    @Override
	public void beforeJob(JobExecution execution)
	{
		this.logger.debug("Before Job: Beginning Job Execution");
	}
}
