package gov.va.cpss.job.apps;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;

import java.util.List;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.support.ClassifierCompositeItemWriter;

import gov.va.cpss.model.apps.APSSite;

/**
 * 
 * A custom composite / delegate writer for Load APPS batch job,
 * which will send the data to different writers, depending on
 * whether the data have errors or not.
 * 
 * Copyright DXC / VA
 * April 13, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 * 
 */
@SuppressWarnings("nls")
public class APPSDelegateWriter extends ClassifierCompositeItemWriter<Entry<APSSite, ? extends List<?>>> implements StepExecutionListener
{
    protected final Log logger = LogFactory.getLog(getClass());

    protected JobExecution jobExecution;

    @Override
    public void beforeStep(StepExecution stepExecution)
    {
        this.logger.info("Before Step Execution");

        // Save the job execution at the beginning of the step.
        // The execution context will be used to set key values as data is processed.
        this.jobExecution = stepExecution.getJobExecution();
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution)
    {
        this.logger.info("After Step Execution.");

        if (this.jobExecution.getExecutionContext().containsKey(JOB_FAILURE_KEY))
        {
            return ExitStatus.FAILED;
        }

        return ExitStatus.COMPLETED;
    }
}
